#pragma once

#include <util/thread/factory.h>
#include <util/system/thread.h>

class TStackSizedThreadFactory : public IThreadFactory {
public:
    explicit TStackSizedThreadFactory(size_t stackSize) noexcept;

    IThread* DoCreate() override;

    class TPoolThread : public IThread {
    public:
        explicit TPoolThread(size_t stackSize) noexcept;

        ~TPoolThread() override;

        void DoRun(IThreadAble* func) override;

        void DoJoin() noexcept override;

    private:
        static void* ThreadProc(void* func);

    private:
        THolder<TThread> Thr_;
        size_t StackSize;
    };

private:
    size_t StackSize;
};
