#pragma once

#ifndef SO_UDNSCONTEXT
#define SO_UDNSCONTEXT

#include <errno.h>
#include <string>
#include <vector>

#include <util/system/mutex.h>
#include <contrib/deprecated/udns/udns.h>
#include <mail/so/spamstop/tools/so-common/ipv6.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>

class TUdnsContextHolder {
public:
    TUdnsContextHolder(TString sLbl = "")
        : bReady(false)
    {
        context = dns_new(nullptr);
        if (sLbl.length() > 0)
            sLabel = sLbl;
        else
            sLabel = "loc";
    }
    ~TUdnsContextHolder() {
        if (context) {
            dns_close(context);
            dns_free(context);
        }
    }

    bool Open(const TLog& logger, TString sSrv = "", int dns_timeout = 50);

    void SetLabel(const TString sLbl) {
        if (sLbl.length() > 0)
            sLabel = sLbl;
    }

    bool ResolveHost(const TLog& logger, const char* sHost, TString *unistatRow, TVector<TString>& addrs, int* errorcode = nullptr);

    bool ResolveAddr(const TLog& logger, const TIpAddr& host, TString * sStr);

    bool ResolveMX(const TLog& logger, const TString& domain, TString *unistatRow, TString * sStr);

    bool IsReady() {
        return bReady;
    }

    static TString ErrorWord(int eCode);

private:
    long long timevalDiff(struct timeval& t1, struct timeval& t2);

private:
    volatile bool bReady;
    dns_ctx* context;
    TString sLabel;
    TString srv_addr;
};

//dns_rr_ptr* dns_resolve_ptr(struct dns_ctx* ctx, const TIpAddr& addr);
//dns_rr_ptr* dns_resolve_ptr(struct dns_ctx* ctx, const struct in_addr* addr);
//dns_rr_ptr* dns_resolve_ptr(struct dns_ctx* ctx, const struct in6_addr* addr);
//
//dns_rr_a4* dns_resolve_dnsbl(struct dns_ctx* ctx, const TIpAddr& addr, const char* dnsbl);
//dns_rr_a4* dns_resolve_dnsbl(struct dns_ctx* ctx, const struct in_addr* addr, const char* dnsbl);
//dns_rr_a4* dns_resolve_dnsbl(struct dns_ctx* ctx, const struct in6_addr* addr, const char* dnsbl);
//
//dns_rr_txt* dns_resolve_dnsbl_txt(struct dns_ctx* ctx, const TIpAddr& addr, const char* dnsbl);
//dns_rr_txt* dns_resolve_dnsbl_txt(struct dns_ctx* ctx, const struct in_addr* addr, const char* dnsbl);
//dns_rr_txt* dns_resolve_dnsbl_txt(struct dns_ctx* ctx, const struct in6_addr* addr, const char* dnsbl);

#endif
