package ru.yandex.antifraud;

import javax.annotation.Nonnull;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;

public abstract class JsonHandler<T extends HttpProxy<?>> implements HttpAsyncRequestHandler<JsonObject> {
    @Nonnull
    protected final T server;

    protected JsonHandler(@Nonnull T server) {
        this.server = server;
    }

    public ProxySession makeSession(final HttpAsyncExchange exchange,
                                    final HttpContext context) throws HttpException {
        return new BasicProxySession(server, exchange, context);
    }

    @Override
    public HttpAsyncRequestConsumer<JsonObject> processRequest(HttpRequest httpRequest,
                                                               HttpContext httpContext) throws HttpException {
        if (!(httpRequest instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Payload expected");
        }
        return new JsonAsyncTypesafeDomConsumer(
                ((HttpEntityEnclosingRequest) httpRequest).getEntity(),
                StringCollectorsFactory.INSTANCE,
                BasicContainerFactory.INSTANCE);
    }
}
