package ru.yandex.antifraud;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.protocol.HttpContext;

import ru.yandex.antifraud.artefacts.LuaClient;
import ru.yandex.antifraud.channel.EntriesDeque;
import ru.yandex.antifraud.util.LuaParsingCallback;
import ru.yandex.function.Processable;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.CallbackFutureBase;
import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.nio.UngzippingByteArrayProcessableAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.RequestsListener;

public class Loop extends AbstractFilterFutureCallback<Void, Void> {
    @Nonnull
    private final Map<String, Map.Entry<ImmutableHttpHostConfig, AbstractAsyncClient<?>>> clients;
    @Nullable
    private final EntriesDeque.Entry entry;
    @Nonnull
    private final EntriesDeque.Context context;
    @Nonnull
    private final Logger logger;
    @Nonnull
    private final RequestsListener listener;
    @Nonnull
    private final HttpContext httpContext;
    @Nonnull
    private final Executor executor;

    public Loop(@Nullable EntriesDeque.Entry entry,
                @Nonnull EntriesDeque.Context context,
                @Nonnull HttpContext httpContext,
                @Nonnull RequestsListener listener,
                @Nonnull Logger logger,
                @Nonnull Map<String, Map.Entry<ImmutableHttpHostConfig, AbstractAsyncClient<?>>> clients,
                @Nonnull Executor executor,
                @Nonnull FutureCallback<Void> callback) {
        super(callback);
        this.entry = entry;
        this.context = context;
        this.clients = clients;
        this.httpContext = httpContext;
        this.listener = listener;
        this.logger = logger;
        this.executor = executor;
    }

    @Override
    public void completed(Void unused) {
        executor.execute(this::execute);
    }

    public void execute() {
        try {
            if (entry != null && !entry.isEmpty()) {
                try {
                    entry.accept(context);
                } catch (RuntimeException e) {
                    context.updateContext("stage failed", e);
                }
            }

            final List<LuaClient.LuaRequest> requests = context.artefacts().luaClient().moveRequests();

            if (!requests.isEmpty()) {
                final MultiFutureCallback<Runnable> runnables =
                        new MultiFutureCallback<>(new CollectRunnables(this));

                for (LuaClient.LuaRequest request : requests) {
                    final Map.Entry<ImmutableHttpHostConfig, AbstractAsyncClient<?>> pair =
                            clients.getOrDefault(request.clientName(), null);
                    if (pair != null) {
                        final AbstractAsyncClient<?> client = pair.getValue().adjust(httpContext);

                        final FutureCallback<Processable<byte[]>> callback;

                        if (!request.isEmpty()) {
                            callback = new LuaParsingCallback(request.makeCallback(runnables.newCallback()));
                        } else {
                            callback = EmptyFutureCallback.instance();
                        }

                        client.execute(
                                pair.getKey().host(),
                                request.makeRequest(),
                                UngzippingByteArrayProcessableAsyncConsumerFactory.OK,
                                listener.createContextGeneratorFor(client),
                                callback);
                    } else {
                        logger.warning("unknown client " + request.clientName());
                    }
                }
                runnables.done();
                return;
            }
            callback.completed(null);
        } catch (Exception e) {
            failed(e);
        }
    }

    class CollectRunnables extends CallbackFutureBase<Void, List<Runnable>> {

        protected CollectRunnables(FutureCallback<Void> callback) {
            super(callback);
        }

        @Override
        protected Void convertResult(List<Runnable> result) {
            if (entry != null) {
                for (Runnable runnable : result) {
                    if (runnable != null) {
                        entry.addStage((unused) -> runnable.run());
                    }
                }
            }
            return null;
        }
    }
}
