package ru.yandex.antifraud;

import javax.annotation.Nonnull;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.antifraud.artefacts.Artefacts;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;

public class SaveCallback
        extends AbstractProxySessionCallback<Artefacts> {
    public SaveCallback(ProxySession session) {
        super(session);
    }

    @Override
    public void completed(@Nonnull Artefacts resolution) {
        session.response(
                HttpStatus.SC_OK,
                new NStringEntity(
                        "OK",
                        ContentType.TEXT_PLAIN.withCharset(session.acceptedCharset())));
    }
}
