package ru.yandex.antifraud;


import javax.annotation.Nonnull;

import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.antifraud.artefacts.Artefacts;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.writer.JsonType;

class ScoreCallback
        extends AbstractProxySessionCallback<Artefacts> {

    public ScoreCallback(@Nonnull ProxySession session) {
        super(session);
    }

    @Override
    public void completed(Artefacts response) {
        session.response(
                response.statusCode(),
                new NStringEntity(
                        JsonType.NORMAL.toString(response.getResolution().asJson()),
                        ContentType.APPLICATION_JSON.withCharset(session.acceptedCharset())));
    }
}
