package ru.yandex.antifraud;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Supplier;

import javax.annotation.Nonnull;

import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.encode.MetricEncoder;
import ru.yandex.monlib.metrics.encode.json.MetricJsonEncoder;


public class SolomonHandler implements HttpAsyncRequestHandler<HttpRequest> {
    @Nonnull
    private final Supplier<MetricSupplier> metricSupplier;

    public SolomonHandler(@Nonnull Supplier<MetricSupplier> metricSupplier) {
        this.metricSupplier = metricSupplier;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
            final HttpRequest request,
            final HttpContext context) {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
            final HttpRequest request,
            final HttpAsyncExchange exchange,
            final HttpContext context) throws IOException {

        final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (MetricEncoder e = new MetricJsonEncoder(stream)) {
            metricSupplier.get().supply(0, e);
        }

        exchange.getResponse().setEntity(
                new NStringEntity(stream.toString(Charset.defaultCharset()), ContentType.APPLICATION_JSON));

        exchange.submitResponse();
    }
}

