package ru.yandex.antifraud;

import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

import javax.annotation.Nonnull;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.antifraud.channel.ChannelResolver;
import ru.yandex.antifraud.lua_context_manager.UnknownChannelException;
import ru.yandex.antifraud.storage.CountersSingleUpdateRequest;
import ru.yandex.antifraud.storage.StorageClient;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;


public class UpdateCounterHandler extends JsonHandler<AntiFraudHttpServer> {
    @Nonnull
    private final StorageClient storageClient;
    @Nonnull
    private final AtomicReference<? extends ChannelResolver> channelResolver;

    public UpdateCounterHandler(@Nonnull AntiFraudHttpServer server,
                                @Nonnull StorageClient storageClient,
                                @Nonnull AtomicReference<? extends ChannelResolver> channelResolver) {
        super(server);
        this.storageClient = storageClient;
        this.channelResolver = channelResolver;
    }

    @Override
    public void handle(
            final JsonObject jsonRequest,
            final HttpAsyncExchange exchange,
            final HttpContext context)
            throws HttpException {
        final ProxySession session = new BasicProxySession(server, exchange, context);

        @Nonnull final CountersSingleUpdateRequest request;
        try {
            request = new CountersSingleUpdateRequest(jsonRequest.asMap(), this.channelResolver.get());
        } catch (JsonException | UnknownChannelException e) {
            session.logger().log(Level.WARNING, "fail to parse update list request", e);
            session.handleException(new BadRequestException(e));
            return;
        }

        final FutureCallback<String> saveCallback = new Callback(session);

        storageClient.save(
                request,
                session.listener(),
                session.context(),
                saveCallback);
    }

    private static class Callback extends AbstractProxySessionCallback<String> {
        public Callback(ProxySession session) {
            super(session);
        }

        @Override
        public void completed(@Nonnull String response) {
            session.response(
                    HttpStatus.SC_OK,
                    new NStringEntity(
                            response,
                            ContentType.TEXT_PLAIN));
        }
    }
}
