package ru.yandex.antifraud;

import java.io.IOException;
import java.util.logging.Level;

import javax.annotation.Nonnull;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.antifraud.channel.config.ChannelConfigDefaults;
import ru.yandex.antifraud.storage.ServiceVerificationLevelSearchUIRequest;
import ru.yandex.antifraud.storage.StorageClient;
import ru.yandex.antifraud.util.ExecutedCallbackFutureBase;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriter;

public class VerificationLevelUiSearchHandler extends JsonHandler<AntiFraudHttpServer> {
    @Nonnull
    private final StorageClient storageClient;

    public VerificationLevelUiSearchHandler(@Nonnull AntiFraudHttpServer server,
                                            @Nonnull StorageClient storageClient) {
        super(server);
        this.storageClient = storageClient;
    }

    @Override
    public void handle(
            final JsonObject jsonRequest,
            final HttpAsyncExchange exchange,
            final HttpContext context)
            throws HttpException {
        final ProxySession session = new BasicProxySession(server, exchange, context);

        @Nonnull final ServiceVerificationLevelSearchUIRequest request;
        try {
            request = new ServiceVerificationLevelSearchUIRequest(jsonRequest.asMap(),
                    ChannelConfigDefaults.INSTANCE.storageLoginIdService());
        } catch (JsonException e) {
            session.logger().log(Level.WARNING, "fail to parse transaction search request", e);
            throw new BadRequestException(e);
        }

        final Callback callback = new Callback(session);

        storageClient.search(
                request,
                session.listener(),
                session.context(),
                new ExecutedCallbackFutureBase<>(server.uiThreadPool(), callback));
    }

    private static class Callback extends AbstractProxySessionCallback<JsonObject> {

        public Callback(ProxySession session) {
            super(session);
        }

        @Override
        public void completed(@Nonnull JsonObject response) {
            final StringBuilderWriter sb = new StringBuilderWriter();

            try (JsonWriter writer = new JsonWriter(sb)) {
                writer.startObject();
                writer.key("levels");

                writer.value(response.get("hitsArray"));

                writer.endObject();
            } catch (IOException|JsonException e) {
                failed(e);
                return;
            }


            session.response(
                    HttpStatus.SC_OK,
                    new NStringEntity(
                            sb.toString(),
                            ContentType.APPLICATION_JSON));
        }
    }
}
