package ru.yandex.antifraud.config;

import java.nio.file.Path;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.lua_context_manager.config.PrototypesConfig;
import ru.yandex.antifraud.model_config.CatboostModelConfig;
import ru.yandex.antifraud.storage.config.StorageConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.logger.LoggerConfig;

public interface AntiFraudConfig extends HttpProxyConfig {
    LoggerConfig deliveryLog();

    @Nonnull
    HttpHostConfig blackboxConfig();

    @Nullable
    HttpHostConfig furyConfig();

    @Nullable
    HttpHostConfig passportConfig();

    @Nullable
    HttpHostConfig passportSlowConfig();

    @Nullable
    HttpHostConfig deduplicatedPassportConfig();

    @Nullable
    HttpHostConfig pharmaConfig();

    @Nullable
    HttpHostConfig trustConfig();

    @Nullable
    HttpHostConfig familyConfig();

    @Nullable
    HttpHostConfig cacheClientConfig();

    @Nonnull
    Map<String, ? extends StorageConfig> mainStorageConfigs();

    @Nonnull
    Map<String, ? extends StorageConfig> uiStorageConfigs();

    @Nonnull
    Tvm2ClientConfig tvm2ClientConfig();

    @Nonnull
    HttpHostConfig rblConfig();

    @Nonnull
    Path rulesConfig();

    @Nonnull
    Path rulesRoot();

    @Nonnull
    PrototypesConfig prototypesConfig();

    @Nonnull
    Map<String, ? extends CatboostModelConfig> models();

    @Nullable
    Path uatraitsConfig();

    @Nonnull
    Path currenciesRatesPath();
}

