package ru.yandex.antifraud.config;

import java.io.IOException;

import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class AntiFraudConfigBuilder
        extends AbstractAntiFraudConfigBuilder<AntiFraudConfigBuilder> {
    public AntiFraudConfigBuilder() {
        super(AntiFraudConfigDefaults.INSTANCE);
    }

    public AntiFraudConfigBuilder(final AntiFraudConfig config) {
        super(config);
    }

    public AntiFraudConfigBuilder(final IniConfig config)
            throws ConfigException, IOException, JsonException {
        super(config, AntiFraudConfigDefaults.INSTANCE);
    }

    public AntiFraudConfigBuilder(
            final IniConfig config,
            final AntiFraudConfig defaults)
            throws ConfigException, IOException, JsonException {
        super(config, defaults);
    }

    @Override
    public AntiFraudConfigBuilder self() {
        return this;
    }

    public ImmutableAntiFraudConfig build() throws ConfigException {
        return new ImmutableAntiFraudConfig(this);
    }
}

