package ru.yandex.antifraud.config;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.lua_context_manager.config.PrototypesConfig;
import ru.yandex.antifraud.lua_context_manager.config.PrototypesConfigDefaults;
import ru.yandex.antifraud.model_config.CatboostModelConfig;
import ru.yandex.antifraud.storage.config.StorageConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigDefaults;

public class AntiFraudConfigDefaults
        extends HttpProxyConfigDefaults
        implements AntiFraudConfig {

    public static final AntiFraudConfigDefaults INSTANCE =
            new AntiFraudConfigDefaults();

    protected AntiFraudConfigDefaults() {
    }

    @Override
    public LoggerConfig deliveryLog() {
        return LoggerConfigDefaults.INSTANCE;
    }

    @Override
    @Nonnull
    public Path rulesConfig() {
        return Path.of(rulesRoot().toString(), "./rules.conf").toAbsolutePath();
    }

    @Override
    @Nonnull
    public Path rulesRoot() {
        return Path.of(System.getProperty("user.dir")).toAbsolutePath();
    }

    @Nonnull
    @Override
    public PrototypesConfig prototypesConfig() {
        return PrototypesConfigDefaults.INSTANCE;
    }

    @Nonnull
    @Override
    public HttpHostConfig blackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nullable
    @Override
    public HttpHostConfig furyConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nullable
    @Override
    public HttpHostConfig passportConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nullable
    @Override
    public HttpHostConfig passportSlowConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nullable
    @Override
    public HttpHostConfig deduplicatedPassportConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nullable
    @Override
    public HttpHostConfig pharmaConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nullable
    @Override
    public HttpHostConfig trustConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nullable
    @Override
    public HttpHostConfig familyConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nullable
    @Override
    public HttpHostConfig cacheClientConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nonnull
    @Override
    public Map<String, ? extends StorageConfig> mainStorageConfigs() {
        return Collections.emptyMap();
    }

    @Nonnull
    @Override
    public Map<String, ? extends StorageConfig> uiStorageConfigs() {
        return Collections.emptyMap();
    }

    @Nonnull
    @Override
    public HttpHostConfig rblConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Nonnull
    @Override
    public Tvm2ClientConfig tvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Nonnull
    @Override
    public Map<String, ? extends CatboostModelConfig> models() {
        return Collections.emptyMap();
    }

    @Override
    @Nullable
    public Path uatraitsConfig() {
        return null;
    }

    @Override
    @Nonnull
    public Path currenciesRatesPath() {
        throw new NullPointerException();
    }
}

