package ru.yandex.antifraud.config;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.lua_context_manager.config.ImmutablePrototypesConfig;
import ru.yandex.antifraud.model_config.CatboostModelConfig;
import ru.yandex.antifraud.model_config.ImmutableCatboostModelConfig;
import ru.yandex.antifraud.storage.config.ImmutableStorageConfig;
import ru.yandex.antifraud.storage.config.StorageConfig;
import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableAntiFraudConfig
        extends ImmutableHttpProxyConfig
        implements AntiFraudConfig {
    private final ImmutableLoggerConfig loggerConfig;
    private final Path rulesRoot;
    private final Path rulesConfig;
    private final Path currenciesRatesPath;
    private final ImmutablePrototypesConfig prototypesConfig;
    private final ImmutableHttpHostConfig blackboxConfig;
    private final ImmutableHttpHostConfig furyConfig;
    private final ImmutableHttpHostConfig passportConfig;
    private final ImmutableHttpHostConfig passportSlowConfig;
    private final ImmutableHttpHostConfig deduplicatedPassportConfig;
    private final ImmutableHttpHostConfig pharmaConfig;
    private final ImmutableHttpHostConfig trustConfig;
    private final ImmutableHttpHostConfig familyConfig;
    private final ImmutableHttpHostConfig cacheClientConfig;
    private final Map<String, ImmutableStorageConfig> mainStorageConfigs;
    private final Map<String, ImmutableStorageConfig> uiStorageConfigs;
    private final ImmutableHttpHostConfig rblConfig;
    private final ImmutableTvm2ClientConfig tvm2ClientConfig;
    private final Map<String, ImmutableCatboostModelConfig> models;
    private final Path uatraitsConfig;

    public ImmutableAntiFraudConfig(final AntiFraudConfig config)
            throws ConfigException {
        super(config);
        loggerConfig = new ImmutableLoggerConfig(config.deliveryLog());

        prototypesConfig = new ImmutablePrototypesConfig(config.prototypesConfig());
        rulesRoot = config.rulesRoot();
        rulesConfig = config.rulesConfig();
        blackboxConfig = new ImmutableHttpHostConfig(config.blackboxConfig());

        if (config.furyConfig() != null) {
            furyConfig = new ImmutableHttpHostConfig(config.furyConfig());
        } else {
            furyConfig = null;
        }

        if (config.passportConfig() != null) {
            passportConfig = new ImmutableHttpHostConfig(config.passportConfig());
        } else {
            passportConfig = null;
        }

        if (config.passportSlowConfig() != null) {
            passportSlowConfig = new ImmutableHttpHostConfig(config.passportSlowConfig());
        } else {
            passportSlowConfig = null;
        }

        if (config.deduplicatedPassportConfig() != null) {
            deduplicatedPassportConfig = new ImmutableHttpHostConfig(config.deduplicatedPassportConfig());
        } else {
            deduplicatedPassportConfig = null;
        }

        if (config.pharmaConfig() != null) {
            pharmaConfig = new ImmutableHttpHostConfig(config.pharmaConfig());
        } else {
            pharmaConfig = null;
        }

        if (config.trustConfig() != null) {
            trustConfig = new ImmutableHttpHostConfig(config.trustConfig());
        } else {
            trustConfig = null;
        }

        if (config.familyConfig() != null) {
            familyConfig = new ImmutableHttpHostConfig(config.familyConfig());
        } else {
            familyConfig = null;
        }

        if (config.cacheClientConfig() != null) {
            cacheClientConfig = new ImmutableHttpHostConfig(config.cacheClientConfig());
        } else {
            cacheClientConfig = null;
        }

        mainStorageConfigs = new HashMap<>();
        for (final Map.Entry<String, ? extends StorageConfig> kv : config.mainStorageConfigs().entrySet()) {
            mainStorageConfigs.put(kv.getKey(), new ImmutableStorageConfig(kv.getValue()));
        }

        uiStorageConfigs = new HashMap<>();
        for (final Map.Entry<String, ? extends StorageConfig> kv : config.uiStorageConfigs().entrySet()) {
            uiStorageConfigs.put(kv.getKey(), new ImmutableStorageConfig(kv.getValue()));
        }

        rblConfig = new ImmutableHttpHostConfig(config.rblConfig());
        tvm2ClientConfig = new ImmutableTvm2ClientConfig(config.tvm2ClientConfig());

        if (!config.models().isEmpty()) {
            models = new HashMap<>(config.models().size());

            for (Map.Entry<String, ? extends CatboostModelConfig> entry : config.models().entrySet()) {
                models.put(entry.getKey(), new ImmutableCatboostModelConfig(entry.getValue()));
            }
        } else {
            models = Collections.emptyMap();
        }

        uatraitsConfig = config.uatraitsConfig();

        currenciesRatesPath = config.currenciesRatesPath();
    }

    @Override
    public ImmutableLoggerConfig deliveryLog() {
        return loggerConfig;
    }

    @Override
    @Nonnull
    public Path rulesConfig() {
        return rulesConfig;
    }

    @Override
    @Nonnull
    public Path rulesRoot() {
        return rulesRoot;
    }

    @Nonnull
    @Override
    public ImmutablePrototypesConfig prototypesConfig() {
        return prototypesConfig;
    }

    @Nonnull
    @Override
    public ImmutableHttpHostConfig blackboxConfig() {
        return blackboxConfig;
    }

    @Nullable
    @Override
    public ImmutableHttpHostConfig furyConfig() {
        return furyConfig;
    }

    @Nonnull
    @Override
    public Map<String, ImmutableStorageConfig> mainStorageConfigs() {
        return mainStorageConfigs;
    }

    @Nonnull
    @Override
    public Map<String, ImmutableStorageConfig> uiStorageConfigs() {
        return uiStorageConfigs;
    }

    @Nullable
    @Override
    public ImmutableHttpHostConfig pharmaConfig() {
        return pharmaConfig;
    }

    @Nullable
    @Override
    public ImmutableHttpHostConfig trustConfig() {
        return trustConfig;
    }

    @Nonnull
    @Override
    public ImmutableHttpHostConfig rblConfig() {
        return rblConfig;
    }

    @Nullable
    @Override
    public ImmutableHttpHostConfig familyConfig() {
        return familyConfig;
    }

    @Nullable
    @Override
    public ImmutableHttpHostConfig cacheClientConfig() {
        return cacheClientConfig;
    }

    @Nonnull
    @Override
    public ImmutableTvm2ClientConfig tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    @Nullable
    @Override
    public ImmutableHttpHostConfig passportConfig() {
        return passportConfig;
    }

    @Nullable
    @Override
    public ImmutableHttpHostConfig deduplicatedPassportConfig() {
        return deduplicatedPassportConfig;
    }

    @Nullable
    @Override
    public ImmutableHttpHostConfig passportSlowConfig() {
        return passportSlowConfig;
    }

    @Nonnull
    @Override
    public Map<String, ImmutableCatboostModelConfig> models() {
        return models;
    }

    @Nullable
    @Override
    public Path uatraitsConfig() {
        return uatraitsConfig;
    }

    @Override
    @Nonnull
    public Path currenciesRatesPath() {
        return currenciesRatesPath;
    }
}

