package ru.yandex.antifraud.model_config;

import java.io.File;

import javax.annotation.Nonnull;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractCatboostModelConfigBuilder
        <T extends AbstractCatboostModelConfigBuilder<T>>
        implements CatboostModelConfig {
    @Nonnull
    private File model;

    @Nonnull
    private File dict;

    protected AbstractCatboostModelConfigBuilder(final CatboostModelConfig config) {
        model = config.model();
        dict = config.dict();
    }

    protected AbstractCatboostModelConfigBuilder(
            final IniConfig config,
            final CatboostModelConfig defaults)
            throws ConfigException {
        model = config.getInputFile("model", defaults.model());
        dict = config.getInputFile("dict", defaults.dict());
    }

    @Override
    @Nonnull
    public File model() {
        return model;
    }

    public void model(File model) {
        this.model = model;
    }

    @Override
    @Nonnull
    public File dict() {
        return dict;
    }

    public void dict(File dict) {
        this.dict = dict;
    }

}

