package ru.yandex.antifraud.model_config;

import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class CatboostModelConfigBuilder
        extends AbstractCatboostModelConfigBuilder<CatboostModelConfigBuilder> {
    public CatboostModelConfigBuilder() {
        super(CatboostModelConfigDefaults.INSTANCE);
    }

    public CatboostModelConfigBuilder(final CatboostModelConfig config) {
        super(config);
    }

    public CatboostModelConfigBuilder(final IniConfig config)
            throws ConfigException, IOException {
        super(config, CatboostModelConfigDefaults.INSTANCE);
    }

    public CatboostModelConfigBuilder(
            final IniConfig config,
            final CatboostModelConfig defaults)
            throws ConfigException, IOException {
        super(config, defaults);
    }

    public ImmutableCatboostModelConfig build() throws ConfigException {
        return new ImmutableCatboostModelConfig(this);
    }
}

