package ru.yandex.antifraud.rbl;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.CallbackFutureBase;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.QueryConstructor;

public class RblClient extends AbstractAsyncClient<RblClient> {
    @Nonnull
    private final ImmutableHttpHostConfig config;

    public RblClient(
            @Nonnull final SharedConnectingIOReactor reactor,
            @Nonnull final ImmutableHttpHostConfig config) {
        super(reactor, config);
        this.config = config;
    }

    private RblClient(
            @Nonnull final CloseableHttpAsyncClient client,
            @Nonnull final RblClient sample) {
        super(client, sample);
        config = sample.config;
    }

    @Override
    public RblClient adjust(
            @Nonnull final CloseableHttpAsyncClient client) {
        return new RblClient(client, this);
    }

    public void getIpInfo(
            @Nonnull final String ip,
            final Supplier<? extends HttpClientContext> contextGenerator,
            @Nonnull final FutureCallback<RblData> callback,
            @Nonnull Logger logger) {
        final CallbackProxy callbackProxy = new CallbackProxy(callback, logger);

        try {

            final QueryConstructor query = new QueryConstructor("/check?info=geobase&service=antifraud");
            query.append("ip", ip);

            final BasicAsyncRequestProducerGenerator requestProducerGenerator =
                    new BasicAsyncRequestProducerGenerator(query.toString());
            execute(
                    config.host(),
                    requestProducerGenerator,
                    JsonAsyncTypesafeDomConsumerFactory.OK,
                    contextGenerator,
                    callbackProxy);
        } catch (BadRequestException e) {
            callbackProxy.failed(e);
        }
    }

    private static class CallbackProxy
            extends CallbackFutureBase<RblData, JsonObject> {
        final Logger logger;

        public CallbackProxy(
                FutureCallback<? super RblData> callback,
                @Nonnull Logger logger) {
            super(callback);
            this.logger = logger;
        }

        @Nullable
        @Override
        protected RblData convertResult(@Nonnull final JsonObject jsonObject) {
            try {
                return new RblData(jsonObject);
            } catch (JsonException e) {
                logger.log(Level.WARNING, "fail to parse rbl info, cause by ", e);
                return null;
            }
        }
    }
}
