#!/bin/bash

set -exo pipefail

if [ -n "$1" ]; then
    source $1
fi

if [ -n "$2" ]; then
    export AF_SERVICE=$2
else
    exit 1
fi

# check tvm client id
if [ -z "${PUSH_CLIENT_TVM_CLIENT_ID}" ]; then
    export PUSH_CLIENT_TVM_CLIENT_ID=${TVM_CLIENT_ID}
fi

if [ -z "${PUSH_CLIENT_TVM_CLIENT_ID}" ]; then
    exit 1
fi

#prod https://abc.yandex-team.ru/services/Logbroker/resources/?tag=2&supplier=14&type=47&state=requested&state=approved&state=granted&view=consuming
export PUSH_CLIENT_TVM_SERVER_ID=2001059
# check tvm secret
if [ -z "${PUSH_CLIENT_TVM_SECRET}" ]; then
  export PUSH_CLIENT_TVM_SECRET=${SECRET}
fi

chmod +x ./push-client
cp pushclient_auxiliary.template pushclient_${AF_SERVICE}.conf

sed -i "s/%SERVICE%/$(echo ${AF_SERVICE} | sed -e 's/\//\\\//g')/g" pushclient_${AF_SERVICE}.conf

if [ -z "${PUSH_CLIENT_TVM_SECRET}" ]; then
  SECRET_FILE=$(echo "$BSCONFIG_IDIR/tvm_secret/client_secret" | sed -e 's/\//\\\//g')
  sed -i "s/%TVM_SECRET_FILE%/tvm-secret-file: $SECRET_FILE/g" pushclient_${AF_SERVICE}.conf
  unset PUSH_CLIENT_TVM_SECRET
else
  sed -i "s/%TVM_SECRET_FILE%//g" pushclient_${AF_SERVICE}.conf
fi

./push-client -c pushclient_${AF_SERVICE}.conf -f
