#!/bin/bash
set -exo pipefail

export CPU_CORES=16

export ANTIFRAUD_PORT=80

export ANTIFRAUD_HTTPS_PORT=443

export LOGROTATE_DAYS=1

export PUSHCLIENT_DEFAULT_LOG_NAME="/logs/antifraud-delivery.json.log"

export STORAGE_SAVE_HOST='http://so-fraud-producer.pers.yandex.net'

export STORAGE_AGGREGATION_HOST='http://so-fraud-proxy.pers.yandex.net'

export RBL_HOST='http://rbl.so.yandex.net'

export TVM_API_HOST='https://tvm-api.yandex.net'

export FURY_HOST='https://router-prod.clean-web.yandex.net'

export DEDUPLCATED_PASSPORT_HOST='http://so-fraud-producer.pers.yandex.net'

export CACHE_HOST='http://so-fraud-kv-storage-l7.pers.yandex.net'

export LIST_ALLOWED_SRCS=2026973,2028842,2010890,2028352

export SERVICES_MAPPING_PATH=$BSCONFIG_IDIR/services_mapping.json

export FPAY_PUSH_NOTIFICATION_TEMPLATE_PATH=$BSCONFIG_IDIR/PushNotification.json

export LPM_TEST_TVM_CLIENT=2001794
export LPM_PROD_TVM_CLIENT=2001796

case "$NANNY_SERVICE_ID" in
    so_fraud)
        export SERVER_NAME="fraud.so.yandex-team.ru"

        export RULES_CONFIG_PATH=$BSCONFIG_IDIR/rules/rules.conf

        export PUSHCLIENT_DEFAULT_TOPIC="/mail-so/mail-so-antifraud-log"
        export PUSH_CLIENT_TVM_CLIENT_ID='2019898'
        export PUSH_CLIENTS=(
            "accesslog mail-so/mail-so-antifraud-access-log antifraud-access"
            "apps"
            "auth mail-so/mail-so-antifraud-auth-delivery-log"
            "beru"
            "direct"
            "eda"
            "pharma mail-so/mail-so-pharma-log"
            "taxi"
            "payments market-antifraud/prod/volva-payments payments"
        )

        export TVM_CLIENT_ID=2019898

        export BLACKBOX_HOST='http://blackbox-mail.yandex.net'
        export BLACKBOX_TVM_CLIENT_ID=222

        export PASSPORT_HOST='http://passport-internal.yandex.ru'
        export PASSPORT_TVM_CLIENT_ID=2000078

        export PHARMA_HOST='https://pharma.passport.yandex.net'
        export PHARMA_TVM_CLIENT_ID=2024479

        export TRUST_HOST='https://api.trust.yandex.net'
        export TRUST_TVM_CLIENT_ID=2001800

        export FAMILY_HOST='https://familypay-backend.so.yandex.net'
        export FAMILY_TVM_CLIENT_ID=2021718

        export CARD_FILTER_TVM_ID=2021245

        export BILLING_TVM_CLIENT_ID=2000497

        export MARKET_TVM_CLIENT_ID=2010064

        export YASMS_TVM_CLIENT=2032606

        export DIRECT_WEB_TVM_CLIENT=2000769

        export LPM_TVM_CLIENT=$LPM_PROD_TVM_CLIENT

        export ALLOWED_SRCS=$LPM_PROD_TVM_CLIENT,$LPM_TEST_TVM_CLIENT,$PASSPORT_TVM_CLIENT_ID,2010142,2000079,2024741,2016791,$DIRECT_WEB_TVM_CLIENT

        export CARGO_CRM_CLIENT_ID=2029040
    ;;
    so_fraud_testing)
        export SERVER_NAME="fraud-test.so.yandex-team.ru"

        export RULES_CONFIG_PATH=$BSCONFIG_IDIR/rules/test_rules.conf

        export PUSHCLIENT_DEFAULT_TOPIC="/mail-so/mail-so-antifraud-test-log"
        export PUSH_CLIENT_TVM_CLIENT_ID='2024973'
        export PUSH_CLIENTS=(
            "payments market-antifraud/test/volva-payments payments"
        )

        export TVM_CLIENT_ID=2024973

        export BLACKBOX_HOST='http://blackbox-test.yandex.net'
        export BLACKBOX_TVM_CLIENT_ID=224

        export PASSPORT_HOST='passport-test-internal.yandex.ru'
        export PASSPORT_TVM_CLIENT_ID=2000079

        export PHARMA_HOST='https://pharma-test.passport.yandex.net'
        export PHARMA_TVM_CLIENT_ID=2024481

        export TRUST_HOST='https://api.trust.test.yandex.net'
        export TRUST_TVM_CLIENT_ID=2001798

        export FAMILY_HOST='https://familypay-backend-test.so.yandex.net'
        export FAMILY_TVM_CLIENT_ID=2021716

        export CARD_FILTER_TVM_ID=2021243

        export BILLING_TVM_CLIENT_ID=2000508

        export MARKET_TVM_CLIENT_ID=2010068

        export YASMS_TVM_CLIENT=2032604,2032602

        export DIRECT_WEB_TVM_CLIENT=2000771

        export LPM_TVM_CLIENT=$LPM_TEST_TVM_CLIENT

        export ALLOWED_SRCS=$LPM_PROD_TVM_CLIENT,$LPM_TEST_TVM_CLIENT,$PASSPORT_TVM_CLIENT_ID,2024739,$TRUST_TVM_CLIENT_ID,2016789,$DIRECT_WEB_TVM_CLIENT

        export CARGO_CRM_CLIENT_ID=2029038
    ;;
esac
