#!/bin/bash
set -exo pipefail

source config.sh

tar xf openjdk.tar.xz
tar xf TANKER_OVERDRAFT_UIDS.tar.gz

./decode-unpack-rules.sh rules.tar.gz.enc rules.tar.gz rules

touch $PUSHCLIENT_DEFAULT_LOG_NAME
for log_info in "${PUSH_CLIENTS[@]}"; do
    set -- $log_info
    if [ -n "$3" ]; then
        log_name=$3
    else
        log_name="$1-delivery"
    fi
    touch "/logs/${log_name}.json.log"
done
