#!/bin/bash
set -exo pipefail

CONFIG_SCRIPT=${1:-./config.sh}

source $CONFIG_SCRIPT

PUSH_CLIENTS_ARGS=()
n=${#PUSH_CLIENTS[@]}
for log_info in "${PUSH_CLIENTS[@]}"; do
    set -- $log_info
    if [ -n "$2" ]; then
        export topic=$2
    else
        export topic="mail-so/mail-so-antifraud-$1-log"
    fi
    if [ -n "$3" ]; then
        export log_name=$3
    else
        export log_name="$1-delivery"
    fi
    PUSH_CLIENTS_ARGS=( "${PUSH_CLIENTS_ARGS[@]}" "$1" "$topic" "$log_name" )
done

echo ${PUSH_CLIENTS_ARGS[*]} | xargs -n3 -P$n ./pushclient_auxiliary.sh $CONFIG_SCRIPT
