import logging
import os
import ssl
from django_pgaas import HostManager
from library.python.django.utils import patch_settings_for_arcadia
from library.python.django.locales import extract_locales


def parse_geo_host(geo_host):
    host, geo = geo_host.rsplit(':', 1)
    return host, geo


LOGGER = logging.getLogger(__name__)
LOCALE_PATHS = extract_locales({'ru'})

ALLCAS_CERT_PATH = os.environ.get("ALLCAS_CERT_PATH")
SSL_CONTEXT = ssl.create_default_context(cafile=ALLCAS_CERT_PATH) if ALLCAS_CERT_PATH else None


YT_TOKEN = os.environ.get("YT_TOKEN")
DEBUG = os.environ.get("DEBUG", "0") == "1"
DEBUG_AUTH = os.environ.get("DEBUG_AUTH", "0") == "1"
FORCE_USER = os.environ.get("FORCE_USER")

TVM_ALLOWED_CLIENTS_FROM = os.environ.get("TVM_ALLOWED_CLIENTS_FROM", "tvm_config.json")
TVM_API_CHECK = os.environ.get("TVM_API_CHECK", "1") == "1"

USE_TZ = True
TIME_ZONE = "Europe/Moscow"

# ========== Django settings

SITE_ID = 1

ALLOWED_HOSTS = [
    "*"
]

ROOT_URLCONF = "mail.so.daemons.antifraud.antifraud_django.project.urls"

FORM_RENDERER = "library.python.django.template.backends.forms_renderer.ArcadiaRenderer"

ROOT_DIR = os.environ.get("ROOT_DIR", ".")

CHANNELS_CONFIG = os.environ.get("CHANNELS_CONFIG")

SECRET_KEY = "MyLongAndSecretCorrectHorseBatteryStaple37Django"
STATIC_URL = "/static/"
STATICFILES_DIRS = [
    f"{ROOT_DIR}/static",
]

TEMPLATES = [
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'OPTIONS': {
            'debug': DEBUG,
            'loaders': [
                'library.python.django.template.loaders.resource.Loader',
                'library.python.django.template.loaders.app_resource.Loader',
            ],
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    }
]

STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    'library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder'
]

INSTALLED_APPS = [
    "django.contrib.contenttypes",
    "django.contrib.auth",
    "django.contrib.staticfiles",
    "django.contrib.sites",
    "mail.so.daemons.antifraud.antifraud_django.sofraud",
    "django_yauth",
    "django_idm_api",
    "django_pgaas",
    "django.contrib.messages",
]

AUTH_MIDDLEWARE = 'django_yauth.middleware.YandexAuthMiddleware' if not DEBUG_AUTH else 'django_yauth.middleware.YandexAuthTestMiddleware'

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    AUTH_MIDDLEWARE,
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.gzip.GZipMiddleware'
]

DB_HOSTS = [
    parse_geo_host(get_host) for get_host in os.environ.get("DB_HOSTS").split(";")
]

manager = HostManager(DB_HOSTS)

LOGGER.info("host_string:" + manager.host_string)

DB_NAME = os.environ.get("DB_NAME", 'af-ui')
DB_USER = os.environ.get("DB_USER", 'af-user')
DB_PASSWORD = os.environ.get("DB_PASSWORD")
DB_PORT = int(os.environ.get("DB_PORT", 6432))
DB_CERT_PATH = os.environ.get("DB_CERT_PATH", ALLCAS_CERT_PATH)

DATABASES = {
    'default': {
        'ENGINE': 'django_pgaas.backend',
        'NAME': DB_NAME,
        'USER': DB_USER,
        'PASSWORD': DB_PASSWORD,
        'HOST': manager.host_string,
        'PORT': DB_PORT,
        'OPTIONS': {
            'sslmode': 'verify-full',
            'target_session_attrs': 'read-write',
            'sslrootcert': DB_CERT_PATH
        },
    }
}

# ========== Logging
LOG_PATH = os.getenv("LOG_PATH")
if LOG_PATH:
    logHandler = {
        "class": "logging.handlers.RotatingFileHandler",
        "filename": LOG_PATH,
        "formatter": "main"
    }
else:
    logHandler = {
        "class": "logging.StreamHandler",
        "formatter": "main"
    }

LOGGING = {
    "version": 1,
    "disable_existing_loggers": False,
    "formatters": {
        'main': {
            'format': '{levelname} {asctime} {pathname}:{lineno} {message}',
            'style': '{',
        },
    },
    "handlers": {
        "main": logHandler
    },
    "root": {
        "handlers": ["main"],
        "level": os.getenv("DJANGO_LOG_LEVEL", "INFO"),
    },
}

# ========== TVM django-idm-api
# https://wiki.yandex-team.ru/intranet/idm/api/django/

from django_idm_api.settings import *  # noqa

IDM_TVM_CLIENT_ID = 2001600
IDM_INSTANCE = "production"
IDM_URL_PREFIX = "idm/"
TVM_CLIENT_ID = int(os.environ.get("TVM_CLIENT_ID", 2028842))
TVM_SECRET = os.environ.get("TVM_SECRET")
IDM_API_TVM_SETTINGS = {
    "client_id": TVM_CLIENT_ID,
    "allowed_clients": (TVM_CLIENT_ID, IDM_TVM_CLIENT_ID),
    "secret": TVM_SECRET,
}

# ROLES_HOOKS = "mail.so.daemons.antifraud.antifraud_django.sofraud.library.hooks.Hooks"
# =============================================================================


# ========== Staff for getting login info (for bypassing CORS)
STAFF_TOKEN = os.environ.get("STAFF_TOKEN")
# =============================================================================

# ========== django_yauth:
from django_yauth.settings import *  # noqa

YAUTH_TYPE = "intranet"

from django_yauth.settings import blackbox

blackbox.BLACKBOX_URL = "https://blackbox.yandex-team.ru/blackbox/"
YAUTH_USE_SITES = False

# YAuth импортирует библиотеки не в той последовательности, что tvm,
# поэтому объекты клиентов не совпадают. Берём клиента прямо из tvm.
from tvm2 import protocol

YAUTH_TVM2_BLACKBOX_CLIENT = protocol.BlackboxClientId.ProdYateam
YAUTH_TVM2_CLIENT_ID = TVM_CLIENT_ID
YAUTH_TVM2_SECRET = TVM_SECRET
YAUTH_USE_TVM2_FOR_BLACKBOX = True
YAUTH_TVM2_ALLOWED_CLIENT_IDS = [
    IDM_TVM_CLIENT_ID,
]
YAUTH_TEST_USER = FORCE_USER

if DEBUG_AUTH:
    AUTHENTICATION_BACKENDS = [
        "django_yauth.authentication_mechanisms.dev.UserFromHttpHeaderAuthBackend",
        "django_yauth.authentication_mechanisms.dev.UserFromCookieAuthBackend",
        "django_yauth.authentication_mechanisms.dev.UserFromOsEnvAuthBackend",
    ]
else:
    AUTHENTICATION_BACKENDS = [
        "django_yauth.authentication_mechanisms.cookie.Mechanism",
        "django_yauth.authentication_mechanisms.oauth.Mechanism",
        "django_yauth.authentication_mechanisms.tvm.Mechanism",
    ]
# =============================================================================

SO_FRAUD_BACKEND_HOST = {
    "prod": os.getenv("SO_FRAUD_BACKEND"),
    "testing": os.getenv("SO_FRAUD_TEST_BACKEND"),
}
SO_FRAUD_BACKEND_TVM_ID = {
    "prod": os.getenv("SO_FRAUD_BACKEND_TVM_ID", 2019898),
    "testing": os.getenv("SO_FRAUD_TEST_BACKEND_TVM_ID", 2024973),
}

TRUST_BACKEND_HOST = os.getenv("TRUST_BACKEND_HOST")

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.11/howto/static-files/

STATIC_URL = '/static/'
STATIC_ROOT = '/static'

DATETIME_FORMAT = "Y-m-d H:i:s"

patch_settings_for_arcadia()
