import logging
from logging.handlers import RotatingFileHandler

from django.http import HttpResponse

PONG = HttpResponse("pong")

logger = logging.getLogger()


async def ping(request, *args, **argv):
    return PONG


async def logrotate(request, *args, **argv):
    rotated_logs = 0
    for handler in logger.handlers:
        if isinstance(handler, RotatingFileHandler):
            handler.doRollover()
            rotated_logs += 1
    return HttpResponse(f"rotated {rotated_logs} logs")
