import yt.wrapper as yt
from django.conf import settings

__client = None


def client():
    global __client
    if not __client:
        __client = yt.YtClient("hahn", token=settings.YT_TOKEN)
    return __client


def get_payments_by_id(trust_payment_id: str):
    return list(client().lookup_rows("//home/trust/prod/payments/t_payment", [{
        "trust_payment_id": trust_payment_id
    }], format=yt.JsonFormat()))
