import configparser
import re


def read_roles_from_config(path):
    config = configparser.ConfigParser()
    config.read(path)

    roles_map = {}
    for key, section in config.items():
        if not key.startswith("channels."):
            continue

        channels_uri = section["channel"]
        sub_channel = section.get("subchannel", section.get("sub_channel"))
        if sub_channel:
            channels_uri += '/' + sub_channel

        for role in re.split(R"[,\s]+", section["ui-group-roles"]):
            roles_map.setdefault(role, set()).add(channels_uri)
    return roles_map
