import json

from django import template
from django.core.serializers.json import DjangoJSONEncoder

register = template.Library()


@register.simple_tag
def active(request, pattern):
    path = request.path
    if path == pattern:
        return 'active'
    return ''


@register.filter(is_safe=True)
def js(obj):
    return json.dumps(obj, cls=DjangoJSONEncoder, sort_keys=True)
