from django.shortcuts import redirect
from django.urls import path, reverse

from mail.so.daemons.antifraud.antifraud_django.sofraud.views.views import (
    TestView,
    NewListView,
    ListsSearchView,
    TransactionsSearchView,
    TransactionView,
    IndexView,
    VerificationLevelsSearchView,
    OffChallengeView,
    PredictorView,
    RefundView,
)

app_name = "mail.so.daemons.antifraud.antifraud_django.sofraud"


def redirect_to_prod(view_name: str):
    return lambda request: redirect(reverse(app_name + ':' + view_name, kwargs={'project': 'prod'}))


urlpatterns = [

    path('<slug:project>/', IndexView.as_view(), name='index'),
    path('<slug:project>/update_list', NewListView.as_view(), name='update_list'),
    path('<slug:project>/lists_search', ListsSearchView.as_view(), name='lists_search'),
    path('<slug:project>/transactions_search', TransactionsSearchView.as_view(),
         name='transactions_search'),
    path('<slug:project>/transaction_view', TransactionView.as_view(), name='transaction_view'),
    path('<slug:project>/verification_levels_search', VerificationLevelsSearchView.as_view(),
         name='verification_levels'),
    path('<slug:project>/off_challenge', OffChallengeView.as_view(), name='off_challenge'),
    path('<slug:project>/test', TestView.as_view(), name='test'),
    path('<slug:project>/predictor', PredictorView.as_view(), name='predictor'),
    path('<slug:project>/refund', RefundView.as_view(), name='refund'),

    path('', redirect_to_prod('index'), name='prod-index'),
    path('update_list', redirect_to_prod('update_list'), name='prod-update_list'),
    path('lists_search', redirect_to_prod('lists_search'), name='prod-lists_search'),
    path('transactions_search', redirect_to_prod('transactions_search'),
         name='prod-transactions_search'),
    path('transaction_view', redirect_to_prod('transaction_view'), name='prod-transaction_view'),
    path('verification_levels_search', redirect_to_prod('verification_levels'),
         name='prod-verification_levels'),
    path('off_challenge', redirect_to_prod('off_challenge'), name='prod-off_challenge'),
    path('test', redirect_to_prod('test'), name='prod-test'),

    path('lists_search', redirect_to_prod('lists_search'), name='prod-lists_search'),
]
