const util = (function () {
    function setup_local_storage_select(select) {
        const prefix = select.id + '-';
        const columnsOptions = select.getElementsByTagName("option");
        const elementsByOptions = {};

        init();

        function init() {
            for (const optionEl of columnsOptions) {
                optionEl.selected = localStorage.getItem(prefix + optionEl.value) === "true";
                optionEl.onclick = set_visibilities;
                elementsByOptions[optionEl.value] = document.getElementsByClassName(optionEl.value);
            }

            set_visibilities();
        }

        function set_visibilities() {
            for (const optionEl of columnsOptions) {
                if (optionEl.selected) {
                    localStorage.setItem(prefix + optionEl.value, "true");
                } else {
                    localStorage.removeItem(prefix + optionEl.value);
                }

                for (const el of elementsByOptions[optionEl.value]) {
                    el.hidden = !optionEl.selected;
                }
            }
        }
    }

    return {
        setup_local_storage_select: setup_local_storage_select
    };
})();
