package ru.yandex.antifraud.aggregates;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaTable;

import ru.yandex.json.dom.JsonMap;

public class Aggregates {

    @Nonnull
    public static final LuaTable EMPTY_TABLE = new LuaTable();

    @Nonnull
    public static final Aggregates EMPTY = new Aggregates();

    @Nonnull
    private final JsonMap shortJson;
    @Nonnull
    private final LuaTable full;
    @Nonnull
    private final LuaTable structuredFull;

    private final boolean isValid;

    private final boolean countersAreValid;

    private Aggregates() {
        this(EMPTY_TABLE, JsonMap.EMPTY, EMPTY_TABLE, false, false);
    }

    public Aggregates(@Nonnull LuaTable full, @Nonnull LuaTable structuredFull) {
        this(full, JsonMap.EMPTY, structuredFull, true, true);

    }

    public Aggregates(@Nonnull LuaTable full,
                      @Nonnull JsonMap shortJson,
                      @Nonnull LuaTable structuredFull,
                      boolean isValid,
                      boolean countersAreValid) {
        this.full = full;
        this.shortJson = shortJson;
        this.structuredFull = structuredFull;
        this.isValid = isValid;
        this.countersAreValid = countersAreValid;
    }

    public LuaTable asFull() {
        return full;
    }

    public JsonMap asShortJson() {
        return shortJson;
    }

    public LuaTable structuredFull() {
        return structuredFull;
    }

    public boolean isValid() {
        return isValid;
    }

    public boolean areCountersValid() {
        return countersAreValid;
    }
}
