package ru.yandex.antifraud.aggregates;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.data.AggregatedData;
import ru.yandex.antifraud.data.CollapsedAggregatesResponse;
import ru.yandex.antifraud.data.Counters;
import ru.yandex.antifraud.data.ListItem;
import ru.yandex.antifraud.lua_context_manager.ListsProvider;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class AggregatesBatch implements ListsProvider {
    @Nonnull
    private final Counters counters = new Counters();
    @Nonnull
    private final List<ListItem> lists = new ArrayList<>();
    @Nonnull
    private final AggregatedData aggregatedData = new AggregatedData();
    @Nonnull
    private CollapsedAggregatesResponse collapsedAggregatesResponse = CollapsedAggregatesResponse.EMPTY;
    private boolean collapsedAggrsAreEmpty = true;
    private boolean aggregatedDataIsEmpty = true;
    private boolean countersAreEmpty = true;
    @Nonnull
    private final Diagnostic diagnostic = new Diagnostic();

    public void updateCounters(@Nonnull JsonMap rawCounters) throws JsonException {
        diagnostic.counters += this.counters.update(rawCounters);
        countersAreEmpty = false;
    }

    public void addLists(@Nonnull List<ListItem> lists) {
        this.lists.addAll(lists);
        diagnostic.lists += lists.size();
    }

    @Nonnull
    public AggregatedData getAggregatedData() {
        return aggregatedData;
    }

    public void updateAggregatedData(@Nonnull JsonObject src) throws JsonException {
        diagnostic.aggregates += this.aggregatedData.process(src);
        aggregatedDataIsEmpty = false;
    }

    @Nonnull
    public CollapsedAggregatesResponse getCollapsedAggregatesResponse() {
        return collapsedAggregatesResponse;
    }

    public void setCollapsedAggregatesResponse(@Nonnull CollapsedAggregatesResponse collapsedAggregatesResponse) {
        this.collapsedAggregatesResponse = collapsedAggregatesResponse;
        diagnostic.collapsedAggregates += collapsedAggregatesResponse.getAggregatesList().size();
        collapsedAggrsAreEmpty = false;
    }

    @Override
    @Nonnull
    public ListChecker getLists() {
        return new ListChecker(lists);
    }

    @Nonnull
    public Counters getCounters() {
        return counters;
    }

    public boolean areCollapsedAggrsEmpty() {
        return collapsedAggrsAreEmpty;
    }

    public boolean isAggregatedDataEmpty() {
        return aggregatedDataIsEmpty;
    }

    public boolean areCountersEmpty() {
        return countersAreEmpty;
    }

    public static class Diagnostic implements JsonValue {
        int counters = 0;
        int lists = 0;
        int aggregates = 0;
        int collapsedAggregates = 0;

        @Override
        public void writeValue(final JsonWriterBase writer)
            throws IOException
        {
            writer.startObject();

            writer.key("c");
            writer.value(counters);

            writer.key("l");
            writer.value(lists);

            writer.key("a");
            writer.value(aggregates);

            writer.key("ca");
            writer.value(collapsedAggregates);

            writer.endObject();
        }
    }

    @Nonnull
    public Diagnostic diagnostic() {
        return diagnostic;
    }
}
