package ru.yandex.antifraud.aggregates;

import java.io.IOException;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaInteger;
import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;

import ru.yandex.antifraud.util.AggregatesNamesCache;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.monlib.metrics.primitives.Rate;

public class LongStat implements Stat, StructuredStat {
    private long count = 0;

    public LongStat() {
    }

    public LongStat(long count) {
        this.count = count;
    }

    public void add(long v) {
        count += v;
    }

    @Override
    public void fully(@Nonnull LuaTable target,
                      @Nonnull AggregatesNamesCache.Names names) {
        if (count > 0) {
            target.set(names.luaLongName(), LuaInteger.valueOf(count));
        }
    }

    @Override
    public void brief(@Nonnull LuaTable target,
                      @Nonnull AggregatesNamesCache.Names names) {
        fully(target, names);
    }

    @Override
    public void brief(@Nonnull JsonMap target,
                      @Nonnull AggregatesNamesCache.Names names) {
        if (count > 0) {
            target.put(names.javaLongName(), JsonLong.valueOf(count));
        }
    }

    @Override
    public <T extends Stat> void mergeWith(T stat) {
        count += ((LongStat) stat).count;
    }

    @Override
    public boolean isEmpty() {
        return count == 0;
    }

    @Override
    public StructuredStat copy() {
        return new LongStat(count);
    }

    @Override
    public <T extends StructuredStat> void structuredMerge(@Nonnull T another) throws StatsMergeException {
        if (another instanceof LongStat) {
            count += ((LongStat) another).count;
        } else {
            throw new StatsMergeException(another.getClass().getName() + " is not LongStat");
        }
    }

    @Override
    public void stat(@Nonnull Rate rate) {
        rate.add(count);
    }

    @Override
    @Nonnull
    public JsonObject serialize(@Nonnull ContainerFactory containerFactory) {
        return new JsonLong(count);
    }

    @Override
    @Nonnull
    public LuaValue serialize() {
        return LuaValue.valueOf(count);
    }

    @Override
    public void jsonify(@Nonnull final JsonWriterBase writer)
            throws IOException {
        writer.value(count);
    }

    public long value() {
        return count;
    }
}
