package ru.yandex.antifraud.aggregates;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultiLongStat implements MultiStructuredStat {
    @Nonnull
    protected final Map<String, LongStat> stats = new HashMap<>();

    public void add(@Nullable String key, long value) {
        if (key == null || value <= 0) {
            return;
        }
        stats.computeIfAbsent(
                key,
                ignored -> new LongStat()
        ).add(value);
    }

    @Nonnull
    @Override
    public Map<String, LongStat> stats() {
        return stats;
    }

    @Override
    public void put(@Nonnull String key, @Nonnull StructuredStat value) throws StatsMergeException {
        if (value instanceof LongStat) {
            stats.put(key, (LongStat) value);
        } else {
            throw new StatsMergeException(value.getClass().getName() + " is not LongStat");
        }
    }
}
