package ru.yandex.antifraud.aggregates;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import core.org.luaj.vm2.LuaBoolean;
import core.org.luaj.vm2.LuaInteger;
import core.org.luaj.vm2.LuaTable;

import ru.yandex.antifraud.util.AggregatesNamesCache;
import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonBoolean;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.monlib.metrics.primitives.Rate;

public class SetStringStat extends MultiLongStat implements Stat {
    @Nonnull
    private final Collection<String> reference;

    public SetStringStat(@Nullable String reference) {
        this.reference = Collections.singletonList(reference);
    }

    public SetStringStat(@Nonnull Collection<String> references) {
        this.reference = references;
    }

    public SetStringStat(JsonMap map) throws JsonBadCastException {
        this.reference = Collections.emptyList();
        for (Map.Entry<String, JsonObject> entry : map.entrySet()) {
            stats.put(entry.getKey(), new LongStat(entry.getValue().asLong()));
        }
    }

    public void add(@Nullable Object value) {
        if (value != null) {
            final String s = value.toString();
            if (!s.isEmpty()) {
                stats.computeIfAbsent(s, ignored -> new LongStat()).add(1);
            }
        }
    }

    public void addAll(@Nonnull Collection<String> values) {
        addAll(values.stream());
    }

    public void addAll(@Nonnull Stream<String> values) {
        values.forEach(this::add);
    }

    @Override
    public void fully(@Nonnull LuaTable target,
                      @Nonnull AggregatesNamesCache.Names names) {
        if (stats.isEmpty()) {
            return;
        }
        final LuaTable map = new LuaTable(0, stats.size());
        for (Map.Entry<String, LongStat> entry : stats.entrySet()) {
            map.set(entry.getKey(), entry.getValue().value());
        }
        target.set(names.luaSetName(), map);
        target.set(names.luaCntName(), LuaInteger.valueOf(stats.size()));
    }

    @Override
    public void brief(@Nonnull LuaTable target,
               @Nonnull AggregatesNamesCache.Names names) {
        if (!stats.isEmpty()) {
            target.set(names.luaSetName(), LuaBoolean.valueOf(reference.stream().anyMatch(stats::containsKey)));
            target.set(names.luaCntName(), LuaInteger.valueOf(stats.size()));
        }
    }

    @Override
    public void brief(
            @Nonnull JsonMap target,
            @Nonnull AggregatesNamesCache.Names names) {
        if (!stats.isEmpty()) {
            target.put(names.javaSetName(), JsonBoolean.valueOf(reference.stream().anyMatch(stats::containsKey)));
            target.put(names.javaCntName(), JsonLong.valueOf(stats.size()));
        }
    }

    @Override
    public <T extends Stat> void mergeWith(T stat) {
        for (Map.Entry<String, LongStat> entry : ((SetStringStat) stat).stats.entrySet()) {
            stats.computeIfAbsent(entry.getKey(), ignored -> new LongStat()).mergeWith(entry.getValue());
        }
    }

    @Override
    public void stat(@Nonnull Rate rate) {
        rate.add(stats.size());
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }
}
