package ru.yandex.antifraud.aggregates;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonObject;


public enum StatFactory {
    INSTANCE;

    public Stat fromJson(@Nonnull JsonObject jsonObject) throws JsonBadCastException {
        switch (jsonObject.type()) {
            case LONG:
            case DOUBLE:
                return new LongStat(jsonObject.asLong());
            case MAP:
                return new SetStringStat(jsonObject.asMap());
            default:
                throw new JsonBadCastException(jsonObject, "unsupported type");
        }
    }
}
