package ru.yandex.antifraud.aggregates;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

public class Stats {
    @Nonnull
    protected final Map<Aggregator, Stat> stats = new EnumMap<>(Aggregator.class);

    public void stat(@Nonnull MetricRegistry registry) {
        for (Map.Entry<Aggregator, Stat> entry : stats.entrySet()) {
            if (!entry.getValue().isEmpty()) {
                entry.getValue().stat(registry.rate(entry.getKey().getName()));
            }
        }
    }

    public void put(@Nonnull Aggregator aggregator, @Nonnull Stat stat) {
        stats.put(aggregator, stat);
    }

    public AsFullCleanJson asFullCleanJson() {
        return new AsFullCleanJson();
    }

    public class AsFullCleanJson implements JsonValue {
        @Override
        public void writeValue(final JsonWriterBase writer)
            throws IOException
        {
            writer.startObject();
            for (Map.Entry<Aggregator, Stat> statEntry : stats.entrySet()) {
                if (!statEntry.getValue().isEmpty()) {
                    writer.key(statEntry.getKey().getName());
                    statEntry.getValue().jsonify(writer);
                }
            }
            writer.endObject();
        }
    }

    public void mergeWith(@Nonnull Stats another) {
        for (Map.Entry<Aggregator, Stat> entry : another.stats.entrySet()) {
            final Stat stat = stats.get(entry.getKey());
            if (stat != null) {
                stat.mergeWith(entry.getValue());
            } else {
                stats.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return stats.isEmpty() || stats.values().stream().allMatch(Stat::isEmpty);
    }

    @Nullable
    public Stat getStat(@Nonnull Aggregator aggregator) {
        return stats.get(aggregator);
    }
}
