package ru.yandex.antifraud.aggregates_v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.aggregates.AggregatesScoringContext;
import ru.yandex.antifraud.aggregates.FieldAcceptor;
import ru.yandex.antifraud.aggregates.StatsMergeException;
import ru.yandex.antifraud.data.CollapsedAggregates;

public class ConglomerateAggregatorConsumer {
    @Nonnull
    private final ArrayList<AggregatorConsumer> aggregatorConsumers = new ArrayList<>();

    @Nonnull
    private final Map<FieldAcceptor.FieldAcceptorInstance, Map<AggregatedTimeRange.AggregatedTimeRangeInstance,
            List<AggregatorConsumer>>> aggregatorsIndex = new HashMap<>(FieldAcceptor.values().length);

    public ConglomerateAggregatorConsumer(@Nonnull Collection<AggregatorConsumer> aggregatorConsumers) {
        addAll(aggregatorConsumers);
    }

    public void addAll(Collection<AggregatorConsumer> aggregatorConsumers) {
        this.aggregatorConsumers.addAll(aggregatorConsumers);
        for (AggregatorConsumer aggregatorConsumer : aggregatorConsumers) {
            aggregatorsIndex.computeIfAbsent(aggregatorConsumer.getFieldAcceptorInstance(),
                            ignored -> new HashMap<>(AggregatedTimeRange.values().length))
                    .computeIfAbsent(aggregatorConsumer.getAggregatedTimeRange(),
                            ignored -> new ArrayList<>(aggregatorConsumers.size()))
                    .add(aggregatorConsumer);
        }
    }

    public void accept(AggregatesScoringContext context) {
        for (var fieldEntry : aggregatorsIndex.entrySet()) {
            if (!fieldEntry.getKey().test(context)) {
                continue;
            }
            for (var timeEntry : fieldEntry.getValue().entrySet()) {
                if (!timeEntry.getKey().test(context.getData().getTimestamp())) {
                    continue;
                }

                for (AggregatorConsumer aggregatorConsumer : timeEntry.getValue()) {
                    if (aggregatorConsumer.test(context)) {
                        aggregatorConsumer.accept(context);
                    }
                }
            }
        }
    }

    public void accept(CollapsedAggregates collapsedAggregates) throws StatsMergeException {
        for (var fieldEntry : aggregatorsIndex.entrySet()) {
            if (!fieldEntry.getKey().test(collapsedAggregates)) {
                continue;
            }
            for (var timeEntry : fieldEntry.getValue().entrySet()) {
                if (!timeEntry.getKey().test(collapsedAggregates.getTimestamp())) {
                    continue;
                }

                for (AggregatorConsumer aggregatorConsumer : timeEntry.getValue()) {
                    if (aggregatorConsumer.test(collapsedAggregates)) {
                        aggregatorConsumer.accept(collapsedAggregates);
                    }
                }
            }
        }
    }

    @Nonnull
    public Collection<AggregatorConsumer> getAggregatorConsumers() {
        return aggregatorConsumers;
    }
}
