package ru.yandex.antifraud.aggregates_v2.aggregate_config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AggregatorConfigBuilder
        extends AbstractAggregatorConfigBuilder<AggregatorConfigBuilder> {
    public AggregatorConfigBuilder() {
        super(AggregatorConfigDefaults.INSTANCE);
    }

    public AggregatorConfigBuilder(final AggregatorConfig config) {
        super(config);
    }

    public AggregatorConfigBuilder(IniConfig config)
            throws ConfigException {
        super(config, AggregatorConfigDefaults.INSTANCE);
    }

    public AggregatorConfigBuilder(
            IniConfig config,
            AggregatorConfig defaults)
            throws ConfigException {
        super(config, defaults);
    }

    public ImmutableAggregatorConfig build() {
        return new ImmutableAggregatorConfig(this);
    }
}

