package ru.yandex.antifraud.aggregates_v2.aggregates_config;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.aggregates_v2.aggregate_config.AggregatorConfig;
import ru.yandex.antifraud.aggregates_v2.aggregate_config.AggregatorConfigBuilder;
import ru.yandex.antifraud.aggregates_v2.aggregate_config.AggregatorConfigDefaults;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractAggregatorsConfigBuilder
        <T extends AbstractAggregatorsConfigBuilder<T>>
        implements AggregatorsConfig {
    private Set<AggregatorConfigBuilder> aggregates;

    protected AbstractAggregatorsConfigBuilder(final AggregatorsConfig config) {
        aggregates(config.aggregates());
    }

    protected AbstractAggregatorsConfigBuilder(@Nonnull IniConfig config)
            throws ConfigException {
        final Map<String, IniConfig> sections = config.sections();
        aggregates = new LinkedHashSet<>(sections.size());

        for (IniConfig subConfig : sections.values()) {
            aggregates.add(new AggregatorConfigBuilder(subConfig, AggregatorConfigDefaults.INSTANCE));
        }
    }


    @Override
    public Set<AggregatorConfigBuilder> aggregates() {
        return aggregates;
    }

    public void aggregates(@Nonnull Collection<? extends AggregatorConfig> aggregates) {
        this.aggregates = new LinkedHashSet<>(aggregates.size());

        for (var entry : aggregates) {
            this.aggregates.add(new AggregatorConfigBuilder(entry));
        }
    }
}

