package ru.yandex.antifraud.aggregates_v2.aggregates_config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.aggregates.AggregatesScoringContext;
import ru.yandex.antifraud.aggregates.FieldAcceptor;
import ru.yandex.antifraud.aggregates_v2.AggregatedTimeRange;
import ru.yandex.antifraud.aggregates_v2.AggregatorConsumer;
import ru.yandex.antifraud.aggregates_v2.ConglomerateAggregatorConsumer;
import ru.yandex.antifraud.aggregates_v2.aggregate_config.AggregatorConfig;
import ru.yandex.antifraud.aggregates_v2.aggregate_config.ImmutableAggregatorConfig;

public class ImmutableAggregatorsConfig implements AggregatorsConfig {
    private final List<ImmutableAggregatorConfig> aggregates;
    @Nonnull
    private final Map<FieldAcceptor, Set<AggregatedTimeRange>> timeRangesByFieldAcceptors;

    public ImmutableAggregatorsConfig(final AggregatorsConfig config) {
        aggregates = new ArrayList<>(config.aggregates().size());
        timeRangesByFieldAcceptors = new HashMap<>(FieldAcceptor.values().length);

        for (var aggregate : config.aggregates()) {
            final ImmutableAggregatorConfig aggregatorConfig = new ImmutableAggregatorConfig(aggregate);
            aggregates.add(aggregatorConfig);

            for (FieldAcceptor fieldAcceptor : aggregatorConfig.fieldAcceptors()) {
                timeRangesByFieldAcceptors
                        .computeIfAbsent(fieldAcceptor, ignored -> new LinkedHashSet<>())
                        .addAll(aggregatorConfig.timeRanges());
            }
        }
    }

    @Override
    public List<? extends AggregatorConfig> aggregates() {
        return aggregates;
    }

    public Map<FieldAcceptor, Set<AggregatedTimeRange>> timeRangesByFieldAcceptors() {
        return timeRangesByFieldAcceptors;
    }

    public ConglomerateAggregatorConsumer materialize(@Nonnull AggregatesScoringContext context) {
        final List<AggregatorConsumer> aggregatorInstances = new ArrayList<>();

        for (final ImmutableAggregatorConfig aggregatorConfig : aggregates) {
            aggregatorConfig.materialize(context, aggregatorInstances::add);
        }

        return new ConglomerateAggregatorConsumer(aggregatorInstances);
    }
}

