package ru.yandex.antifraud.artefacts;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

import javax.annotation.Nonnull;

import core.org.luaj.vm2.LuaTable;
import org.apache.http.HttpStatus;

import ru.yandex.antifraud.channel.ChannelResolver;
import ru.yandex.antifraud.channel.config.ImmutableChannelConfig;
import ru.yandex.antifraud.data.ScoringData;
import ru.yandex.antifraud.storage.UpdateRequest;

public class Artefacts {
    private int statusCode = HttpStatus.SC_OK;
    private final Resolution resolution;
    private final PreparedCounters counters;
    private final List<String> listsChecks = new ArrayList<>();
    private final StringJoiner comments = new StringJoiner("\n");
    private final List<UpdateRequest> updateRequests = new ArrayList<>();
    private final PreparedLists preparedLists;
    private final StringJoiner queues = new StringJoiner("\n");
    private final LuaTable scriptLog, rootLog;
    private final LuaClient luaClient = new LuaClient();
    private boolean interrupted = false;

    public Artefacts(@Nonnull ScoringData scoringData,
                     @Nonnull ImmutableChannelConfig channelConfig,
                     @Nonnull ChannelResolver channelResolver) {
        this.resolution = new Resolution(scoringData.makeTxId());
        preparedLists = new PreparedLists(channelResolver, updateRequests::add);
        counters = new PreparedCounters(scoringData.getTimestamp(), channelConfig, channelResolver,
                updateRequests::add);

        rootLog = new LuaTable();
        scriptLog = new LuaTable();
        rootLog.set("script_log", scriptLog);
    }

    public List<String> getListsChecks() {
        return listsChecks;
    }

    public List<UpdateRequest> updateRequests() {
        return updateRequests;
    }

    @Nonnull
    public PreparedLists getLists() {
        return preparedLists;
    }

    public Resolution getResolution() {
        return resolution;
    }

    public void statusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int statusCode() {
        return statusCode;
    }

    @Nonnull
    public StringJoiner getQueues() {
        return queues;
    }

    @Nonnull
    public LuaTable scriptLog() {
        return scriptLog;
    }

    @Nonnull
    public LuaTable rootLog() {
        return rootLog;
    }

    public PreparedCounters getCounters() {
        return counters;
    }

    @Nonnull
    public LuaClient luaClient() {
        return luaClient;
    }

    @Nonnull
    public StringJoiner getComments() {
        return comments;
    }

    public void interrupt() {
        interrupted = true;
    }

    public boolean interrupted() {
        return interrupted;
    }
}
