package ru.yandex.antifraud.bb;

import ru.yandex.blackbox.BlackboxAliasType;
import ru.yandex.blackbox.BlackboxAttributeType;
import ru.yandex.blackbox.BlackboxPhoneAttributeType;
import ru.yandex.blackbox.BlackboxUserinfoRequest;

public enum BBRequestMaker {
    INSTANCE;

    public BlackboxUserinfoRequest makeBlackboxRequest(long uid) {
        final BlackboxUserinfoRequest bbRequest = new BlackboxUserinfoRequest(uid);
        bbRequest.attributes(
                BlackboxAttributeType.ACCOUNT_REGISTRATION_DATETIME,
                BlackboxAttributeType.PERSON_COUNTRY,
                BlackboxAttributeType.IS_SHARED,
                BlackboxAttributeType.ACCOUNT_SMS_2FA_ON,
                BlackboxAttributeType.IS_APP_PASSWORD_ENABLED,
                BlackboxAttributeType.PHONES_SECURE,
                BlackboxAttributeType.ACCOUNT_2FA_ON,
                BlackboxAttributeType.ACCOUNT_HAVE_PLUS);
        bbRequest.phoneAttributes(
                BlackboxPhoneAttributeType.PHONE_E164_NUMBER,
                BlackboxPhoneAttributeType.PHONE_MASKED_E164_NUMBER,
                BlackboxPhoneAttributeType.IS_BOUND,
                BlackboxPhoneAttributeType.IS_SECURED);
        bbRequest.aliases(BlackboxAliasType.ALL);

        return bbRequest;
    }
}
