package ru.yandex.antifraud.channel;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.channel.config.ImmutableChannelConfig;
import ru.yandex.antifraud.data.ScoringData;
import ru.yandex.antifraud.lua_context_manager.UnknownChannelException;

public interface ChannelResolver {
    @Nonnull
    ImmutableChannelConfig resolve(@Nonnull String channel, @Nullable String subChannel) throws UnknownChannelException;

    @Nonnull
    ImmutableChannelConfig resolve(@Nonnull String serviceId) throws UnknownChannelException;

    @Nonnull
    default ImmutableChannelConfig resolve(@Nonnull ScoringData scoringData) throws UnknownChannelException {

        final String channel = scoringData.getChannel();
        if (channel != null) {
            try {
                return resolve(channel, scoringData.getSubChannel());
            } catch (UnknownChannelException ignored) {
            }
        }

        final String serviceId = scoringData.getServiceId();
        if (serviceId != null) {
            return resolve(serviceId);
        }

        throw new UnknownChannelException("cannot resolve channel: " + channel + '/' + scoringData.getSubChannel());
    }
}
