package ru.yandex.antifraud.channel;

import java.util.List;

import javax.annotation.Nonnull;

import ru.yandex.antifraud.channel.config.ImmutableChannelConfig;

public class ChannelWithCrossChannels {
    @Nonnull
    private final Channel channel;
    @Nonnull
    private final List<ImmutableChannelConfig> crossChannelsConfigs;

    public ChannelWithCrossChannels(@Nonnull Channel channel,
                                    @Nonnull List<ImmutableChannelConfig> crossChannelsConfigs) {
        this.channel = channel;
        this.crossChannelsConfigs = crossChannelsConfigs;
    }

    @Nonnull
    public Channel getChannel() {
        return channel;
    }

    @Nonnull
    public List<ImmutableChannelConfig> getCrossChannelsConfigs() {
        return crossChannelsConfigs;
    }
}
