package ru.yandex.antifraud.channel;


import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.artefacts.Resolution;
import ru.yandex.antifraud.data.ScoringData;
import ru.yandex.antifraud.rbl.RblData;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class ExecutionContext {
    @Nullable
    private final Resolution resolution;
    @Nonnull
    private final ScoringData scoreData;
    @Nullable
    private final ScoringData saveData;
    @Nullable
    private final RblData rblData;
    @Nonnull
    private final List<String> queues;
    @Nonnull
    private final String channelUri;
    @Nonnull
    private final String storageService;

    public ExecutionContext(@Nonnull JsonMap data) throws JsonException {
        {
            final JsonMap rawResolution = data.getMapOrNull("lua_resolution");
            if (rawResolution != null) {
                resolution = new Resolution(rawResolution);
            } else {
                resolution = null;
            }
        }

        scoreData = new ScoringData(data.getMap("score_data"), null);
        {
            final JsonMap saveData = data.getMapOrNull("save_data");
            if (saveData != null) {
                this.saveData = new ScoringData(saveData, null);
            } else {
                this.saveData = null;
            }
        }

        {
            final JsonMap rbl = data.getMapOrNull("rbl");
            if (rbl != null) {
                final JsonObject perUidInfo = rbl.getOrDefault(scoreData.getIp(), null);
                if (perUidInfo != null && perUidInfo.type() != JsonObject.Type.NULL) {
                    rblData = new RblData(perUidInfo);
                } else {
                    rblData = new RblData(rbl);
                }
            } else {
                rblData = null;
            }
        }
        {
            final JsonObject queues = data.getOrDefault("queues", null);
            if (queues != null && queues.type() == JsonObject.Type.LIST && !queues.asList().isEmpty()) {
                this.queues = new ArrayList<>(queues.asList().size());
                for (JsonObject value : queues.asList()) {
                    this.queues.add(value.asString());
                }
            } else {
                this.queues = Collections.emptyList();
            }
        }

        channelUri = data.getString("channel_uri");
        storageService = data.getString("storage_service");
    }

    @Nonnull
    public ScoringData getScoreData() {
        return scoreData;
    }

    @Nullable
    public ScoringData getSaveData() {
        return saveData;
    }

    @Nullable
    public RblData getRblData() {
        return rblData;
    }

    @Nullable
    public Resolution getResolution() {
        return resolution;
    }

    @Nonnull
    public List<String> getQueues() {
        return queues;
    }

    @Nonnull
    public String getChannelUri() {
        return channelUri;
    }

    @Nonnull
    public String getStorageService() {
        return storageService;
    }
}
