package ru.yandex.antifraud.channel.config;

import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.aggregates_v2.aggregates_config.AggregatorsConfig;
import ru.yandex.antifraud.channel.route_config.ChannelRouteConfig;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.CollectionValidator;
import ru.yandex.parser.string.NonEmptyCollectionValidator;
import ru.yandex.parser.string.NonEmptyValidator;

public interface ChannelConfig extends ChannelRouteConfig {
    String ENTRY = "entry";
    String SCRIPT_DIR = "script-dir";
    String DELIVERY_LOG = "delivery-log";

    String PAYMENTS_LOG = "payments-log";
    String STORAGE_SERVICE = "storage-service";
    String STORAGE_LOGIN_ID_SERVICE = "storage-login-id-service";
    String COLLAPSED_AGGRS_BEGIN = "collapsed-aggsr-begin";
    String COLLAPSED_AGGRS_END = "collapsed-aggsr-end";
    String STORE_IN_DB = "store-in-db";

    String AGGREGATORS = "aggregates";

    ParameterConfig<List<String>> CROSS_CHANNELS = new ParameterConfig<>(
            "cross-channels",
            new CollectionParser<>(
                    NonEmptyValidator.TRIMMED,
                    ArrayList::new),
            new CollectionValidator<String, List<String>>(
                    NonEmptyValidator.INSTANCE)
                    .andThen(NonEmptyCollectionValidator.instance())
                    .andThen(ArrayList::new));

    ParameterConfig<Set<String>> FIELDS_TO_EXCLUDE = new ParameterConfig<>(
            "fields-to-exclude",
            new CollectionParser<>(
                    NonEmptyValidator.TRIMMED,
                    HashSet::new),
            new CollectionValidator<String, Set<String>>(
                    NonEmptyValidator.INSTANCE)
                    .andThen(NonEmptyCollectionValidator.instance())
                    .andThen(HashSet::new));

    ParameterConfig<List<String>> LIST_DIR = new ParameterConfig<>(
            "list-dir",
            new CollectionParser<>(
                    NonEmptyValidator.TRIMMED,
                    ArrayList::new),
            new CollectionValidator<String, List<String>>(
                    NonEmptyValidator.INSTANCE)
                    .andThen(NonEmptyCollectionValidator.instance())
                    .andThen(ArrayList::new));

    @Nonnull
    Path entry();

    @Nullable
    List<String> listDir();

    @Nullable
    LoggerConfig deliveryLog();

    @Nullable
    LoggerConfig paymentsLog();

    @Nonnull
    String storageService();

    @Nonnull
    String storageLoginIdService();

    @Nonnull
    Set<String> fieldsToExclude();

    @Nonnull
    List<String> crossChannels();

    @Nonnull
    Duration gapToCollapsedAggrsBegin();

    @Nonnull
    Duration gapToCollapsedAggrsEnd();

    boolean storeInDb();

    @Nonnull
    AggregatorsConfig aggregatorsConfig();
}

