package ru.yandex.antifraud.channel.config;

import java.nio.file.Path;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ChannelConfigBuilder
        extends AbstractChannelConfigBuilder<ChannelConfigBuilder> {
    public ChannelConfigBuilder() {
        super(ChannelConfigDefaults.INSTANCE);
    }

    public ChannelConfigBuilder(final ChannelConfig config) {
        super(config);
    }

    public ChannelConfigBuilder(Path root,
                                IniConfig config)
            throws ConfigException {
        super(root, config, ChannelConfigDefaults.INSTANCE);
    }

    public ChannelConfigBuilder(
            Path root,
            IniConfig config,
            ChannelConfig defaults)
            throws ConfigException {
        super(root, config, defaults);
    }

    @Override
    public ImmutableChannelConfig build() throws ConfigException {
        return new ImmutableChannelConfig(this);
    }
}

