package ru.yandex.antifraud.channel.config;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.aggregates_v2.aggregates_config.AggregatorsConfigDefaults;
import ru.yandex.antifraud.channel.route_config.ChannelRouteConfigDefaults;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigDefaults;

public class ChannelConfigDefaults extends ChannelRouteConfigDefaults
        implements ChannelConfig {

    public static final ChannelConfigDefaults INSTANCE =
            new ChannelConfigDefaults();

    protected ChannelConfigDefaults() {
    }

    @Nonnull
    @Override
    public Path entry() {
        return Path.of("script.lua");
    }

    @Nullable
    @Override
    public List<String> listDir() {
        return Collections.emptyList();
    }

    @Override
    public LoggerConfig deliveryLog() {
        return LoggerConfigDefaults.INSTANCE;
    }

    @Override
    public LoggerConfig paymentsLog() {
        return LoggerConfigDefaults.INSTANCE;
    }

    @Nonnull
    @Override
    public String storageService() {
        return "so_fraud_data";
    }

    @Nonnull
    @Override
    public String storageLoginIdService() {
        return "so_fraud_login_id";
    }

    @Nonnull
    @Override
    public Set<String> fieldsToExclude() {
        return Collections.emptySet();
    }

    @Nonnull
    @Override
    public List<String> crossChannels() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Duration gapToCollapsedAggrsBegin() {
        return Duration.ofDays(-28);
    }

    @Override
    @Nonnull
    public Duration gapToCollapsedAggrsEnd() {
        return Duration.ofDays(-1);
    }

    @Override
    public boolean storeInDb() {
        return true;
    }

    @Override
    @Nonnull
    public AggregatorsConfigDefaults aggregatorsConfig() {
        return AggregatorsConfigDefaults.INSTANCE;
    }
}

