package ru.yandex.antifraud.channel.config;

import java.util.Objects;

import javax.annotation.Nonnull;

public class ServiceChannelUri {
    @Nonnull
    private final String channelUri;

    @Nonnull
    private final String storageService;

    public ServiceChannelUri(@Nonnull String channelUri, @Nonnull String storageService) {
        this.channelUri = channelUri;
        this.storageService = storageService;
    }

    @Nonnull
    public String getChannelUri() {
        return channelUri;
    }

    @Nonnull
    public String getStorageService() {
        return storageService;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceChannelUri)) {
            return false;
        }
        ServiceChannelUri that = (ServiceChannelUri) o;
        return channelUri.equals(that.channelUri) && storageService.equals(that.storageService);
    }

    @Override
    public int hashCode() {
        return Objects.hash(channelUri, storageService);
    }

    @Override
    public String toString() {
        return "ServiceChannelUri{" +
                "channelUri='" + channelUri + '\'' +
                ", storageService='" + storageService + '\'' +
                '}';
    }
}
