package ru.yandex.antifraud.channel.route_config;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractChannelRouteConfigBuilder
        <T extends AbstractChannelRouteConfigBuilder<T>>
        implements ChannelRouteConfig {

    @Nonnull
    private String channel;
    @Nonnull
    private String channelUri;
    @Nullable
    private String subChannel;
    @Nonnull
    private Set<String> serviceIds;

    protected AbstractChannelRouteConfigBuilder(final ChannelRouteConfig config) {
        channel = config.channel();
        subChannel = config.subChannel();
        serviceIds = config.serviceIds();
        channelUri = config.channelUri();
    }

    protected AbstractChannelRouteConfigBuilder(
            @Nonnull IniConfig config,
            @Nonnull ChannelRouteConfig defaults)
            throws ConfigException {
        channel = config.getString("channel");
        subChannel = config.getString("subchannel", config.getString("sub_channel", defaults.subChannel()));

        if (subChannel != null) {
            channelUri = channel + '_' + subChannel;
        } else {
            channelUri = channel;
        }

        serviceIds = new HashSet<>(SERVICE_IDS.extract(config, defaults.serviceIds()));
    }


    @Nonnull
    @Override
    public String channel() {
        return channel;
    }

    public void channel(@Nonnull String channel) {
        this.channel = channel;
    }

    @Nonnull
    @Override
    public String channelUri() {
        return channelUri;
    }

    public void channelUri(@Nonnull String channelUri) {
        this.channelUri = channelUri;
    }

    @Nullable
    @Override
    public String subChannel() {
        return subChannel;
    }

    public void subChannel(String subChannel) {
        this.subChannel = subChannel;
    }

    @Nonnull
    @Override
    public Set<String> serviceIds() {
        return serviceIds;
    }

    public void serviceIds(@Nonnull Set<String> serviceIds) {
        this.serviceIds = Objects.requireNonNull(serviceIds);
    }
}

