package ru.yandex.antifraud.channel.route_config;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.CollectionValidator;
import ru.yandex.parser.string.NonEmptyCollectionValidator;
import ru.yandex.parser.string.NonEmptyValidator;

public interface ChannelRouteConfig {

    ParameterConfig<Set<String>> SERVICE_IDS = new ParameterConfig<>(
            "service-ids",
            new CollectionParser<>(
                    NonEmptyValidator.TRIMMED,
                    HashSet::new),
            new CollectionValidator<String, Set<String>>(
                    NonEmptyValidator.INSTANCE)
                    .andThen(NonEmptyCollectionValidator.instance())
                    .andThen(HashSet::new));

    @Nonnull
    String channel();

    @Nonnull
    String channelUri();

    @Nullable
    String subChannel();

    @Nonnull
    Set<String> serviceIds();
}

