package ru.yandex.antifraud.channel.route_config;

import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.antifraud.storage.query.KeyValueQueryNode;
import ru.yandex.antifraud.storage.query.QueryNode;

public class ImmutableChannelRouteConfig implements ChannelRouteConfig {
    @Nonnull
    private final String channel;
    @Nullable
    private final String subChannel;
    @Nonnull
    private final QueryNode query;
    @Nonnull
    private final String channelUri;
    @Nonnull
    private final Set<String> serviceIds;

    public ImmutableChannelRouteConfig(final ChannelRouteConfig config) {
        channel = config.channel();
        subChannel = config.subChannel();
        serviceIds = config.serviceIds();
        channelUri = config.channelUri();

        this.query = new KeyValueQueryNode("channel_uri", channelUri);
    }

    @Nonnull
    @Override
    public String channel() {
        return channel;
    }

    @Nullable
    @Override
    public String subChannel() {
        return subChannel;
    }

    @Nonnull
    @Override
    public Set<String> serviceIds() {
        return serviceIds;
    }

    public boolean match(@Nonnull String channel, @Nullable String subChannel) {
        if (!this.channel.equals(channel)) {
            return false;
        }

        if (this.subChannel != null && subChannel != null) {
            return this.subChannel.equals(subChannel);
        }

        return true;
    }

    @Nonnull
    public QueryNode getQuery() {
        return query;
    }

    @Override
    @Nonnull
    public String channelUri() {
        return channelUri;
    }
}

